/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.debug.socket;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import dev.felnull.otyacraftengine.client.debug.socket.DebugConnection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocketDebugService {
    private static final Logger LOGGER = LogManager.getLogger(SocketDebugService.class);
    private static final Gson GSON = new Gson();
    private static final boolean enable = true;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final String hostName = "localhost";
    private static final int port = 1919;
    public static DebugConnection connection;
    private static Vector3f rawAngle;
    private static Vector3f angle;
    private static Vector3f oldAngle;
    private static boolean yAngleFlag;
    private static boolean zAngleFlag;
    private static Vector3f rawPosition;
    private static Vector3f position;
    private static Vector3f oldPosition;

    public static void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        ConnectionThread ct = new ConnectionThread();
        ct.start();
    }

    public static void tick() {
        oldAngle = angle;
        angle = rawAngle;
        oldPosition = position;
        position = rawPosition;
    }

    public static void onText(String text) {
        try {
            UUID uuid = UUID.fromString(text);
            connection.sendText(uuid.toString());
            return;
        }
        catch (Exception uuid) {
            try {
                JsonObject jo = (JsonObject)GSON.fromJson(text, JsonObject.class);
                SocketDebugService.parse(jo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private static void parse(JsonObject jo) {
        if (!jo.has("type")) {
            return;
        }
        String type = jo.get("type").getAsString();
        if ("update".equals(type)) {
            yAngleFlag = jo.get("ayflg").getAsBoolean();
            zAngleFlag = jo.get("azflg").getAsBoolean();
            rawAngle = SocketDebugService.createAngle(jo.get("ax").getAsFloat(), SocketDebugService.fixP(jo.get("ay").getAsFloat(), yAngleFlag, zAngleFlag), jo.get("az").getAsFloat());
            boolean yFixAngleFlag = jo.get("ayflgf").getAsBoolean();
            boolean zFixAngleFlag = jo.get("azflgf").getAsBoolean();
            Vector3f fAngle = SocketDebugService.createAngle(jo.get("axf").getAsFloat(), SocketDebugService.fixP(jo.get("ayf").getAsFloat(), yFixAngleFlag, zFixAngleFlag), jo.get("azf").getAsFloat());
            rawAngle.m_122267_(fAngle);
            rawAngle = new Vector3f(SocketDebugService.fixRoted(rawAngle.m_122239_()), SocketDebugService.fixRoted(rawAngle.m_122260_()), SocketDebugService.fixRoted(rawAngle.m_122269_()));
            rawPosition = new Vector3f(jo.get("px").getAsFloat(), jo.get("py").getAsFloat(), jo.get("pz").getAsFloat());
        }
    }

    private static float fixP(float va, boolean revY, boolean revZ) {
        va = 90.0f - va;
        if (revY) {
            va = 180.0f - va + 180.0f;
        }
        return va;
    }

    private static Vector3f createAngle(float rx, float ry, float rz) {
        return new Vector3f(360.0f - SocketDebugService.fixRoted(rx), (SocketDebugService.fixRoted(ry) - 180.0f) % 360.0f, SocketDebugService.fixRoted(rz));
    }

    private static float fixRoted(float val) {
        if (val < 0.0f) {
            return 360.0f + val;
        }
        return val;
    }

    private static float lerpRoted(float delta, float old, float current) {
        float mr = 180.0f;
        float sa = Mth.m_14154_((float)(current - old));
        if (sa > mr) {
            current = old < current ? -(360.0f - current) : 360.0f + current;
        }
        return Mth.m_14179_((float)delta, (float)old, (float)current);
    }

    public static Vector3f getAngele(float delta) {
        return new Vector3f(SocketDebugService.lerpRoted(delta, oldAngle.m_122239_(), angle.m_122239_()), SocketDebugService.lerpRoted(delta, oldAngle.m_122260_(), angle.m_122260_()), SocketDebugService.lerpRoted(delta, oldAngle.m_122269_(), angle.m_122269_()));
    }

    public static Vector3f getPosition(float delta) {
        return new Vector3f(Mth.m_14179_((float)delta, (float)oldPosition.m_122239_(), (float)position.m_122239_()), Mth.m_14179_((float)delta, (float)oldPosition.m_122260_(), (float)position.m_122260_()), Mth.m_14179_((float)delta, (float)oldPosition.m_122269_(), (float)position.m_122269_()));
    }

    public static boolean isConnected() {
        if (connection != null) {
            return connection.isOpen();
        }
        return false;
    }

    private static void connect(String hostName, int port) throws InterruptedException {
        while (mc.m_91396_()) {
            connection = new DebugConnection(hostName, port);
            try {
                connection.run();
            }
            catch (Exception e) {
                LOGGER.error("Socket connection error", (Throwable)e);
                Thread.sleep(1000L);
            }
            finally {
                connection = null;
            }
        }
    }

    static {
        rawAngle = new Vector3f();
        angle = new Vector3f();
        oldAngle = new Vector3f();
        rawPosition = new Vector3f();
        position = new Vector3f();
        oldPosition = new Vector3f();
    }

    private static class ConnectionThread
    extends Thread {
        private ConnectionThread() {
            this.setName("Debug connection");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                SocketDebugService.connect(SocketDebugService.hostName, 1919);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

